//-------------------------------------------------------------------

#include "PotholeDetector.h"
#include <AssetTracker.h>
#include "PotholeReporter.h"
#include "PotholeLocation.h"
#include <queue>

//-------------------------------------------------------------------

bool executeStateMachine = false;
bool ledState = false;

//-------------------------------------------------------------------

#define ONE_DAY_MILLIS (24*60*60*1000)
unsigned long lastSync = millis();

//-------------------------------------------------------------------

std::queue<PotholeLocation> potholeLocations;
AssetTracker locationTracker  = AssetTracker();
PotholeReporter potholeReporter(potholeLocations);
PotholeDetector potholeDetector(potholeLocations, locationTracker);

//-------------------------------------------------------------------

// Timer to schedule execution of state machines

void stateMachineScheduler() {
   executeStateMachine = true;
}

Timer stateMachineTimer(10, stateMachineScheduler);

//-------------------------------------------------------------------

void responseHandler(const char *event, const char *data) {
    // Formatting output
    String output = String::format("POST Response:\n  %s\n  %s\n", event, data);
    // Log to serial console
    Serial.println(output);
}

//-------------------------------------------------------------------

void setup() {
   Serial.begin(115200);
   pinMode(D7, OUTPUT);
   stateMachineTimer.start();

   locationTracker.begin();
   locationTracker.gpsOn();
   
   // Handler response from POSTing location to the server
   Particle.subscribe("hook-response/holz", responseHandler, MY_DEVICES);
}

//-------------------------------------------------------------------

void loop() {
   if( abs(static_cast<int>(millis() - lastSync)) > ONE_DAY_MILLIS ) {
      Particle.syncTime();
      lastSync = millis();
   }

   if (executeStateMachine) {
      locationTracker.updateGPS();
      potholeReporter.execute();  
      potholeDetector.execute();
      executeStateMachine = false;
   }
}

//-------------------------------------------------------------------



